/*
 * Decompiled with CFR 0.152.
 */
package com.james.tinkerscalibration.modifiers;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.TooltipFlag;
import net.minecraftforge.event.entity.player.PlayerEvent;
import slimeknights.mantle.client.TooltipKey;
import slimeknights.tconstruct.common.TinkerTags;
import slimeknights.tconstruct.library.modifiers.Modifier;
import slimeknights.tconstruct.library.modifiers.ModifierEntry;
import slimeknights.tconstruct.library.modifiers.ModifierHooks;
import slimeknights.tconstruct.library.modifiers.hook.build.ConditionalStatModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.combat.MeleeDamageModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.display.TooltipModifierHook;
import slimeknights.tconstruct.library.modifiers.hook.mining.BreakSpeedModifierHook;
import slimeknights.tconstruct.library.module.ModuleHook;
import slimeknights.tconstruct.library.module.ModuleHookMap;
import slimeknights.tconstruct.library.tools.context.ToolAttackContext;
import slimeknights.tconstruct.library.tools.nbt.IToolStackView;
import slimeknights.tconstruct.library.tools.stat.FloatToolStat;
import slimeknights.tconstruct.library.tools.stat.INumericToolStat;
import slimeknights.tconstruct.library.tools.stat.ToolStats;
import slimeknights.tconstruct.tools.TinkerModifiers;
import slimeknights.tconstruct.tools.modifiers.slotless.OverslimeModifier;

public class OverslimeArmyModifier
extends Modifier
implements TooltipModifierHook,
MeleeDamageModifierHook,
BreakSpeedModifierHook,
ConditionalStatModifierHook {
    public int getPriority() {
        return 70;
    }

    public void onBreakSpeed(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull PlayerEvent.BreakSpeed event, @Nonnull Direction sideHit, boolean isEffective, float miningSpeedModifier) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int current = overslime.getShield(tool);
        if (current > 0) {
            event.setNewSpeed((float)((double)event.getNewSpeed() + Math.cbrt((float)current * tool.getMultiplier((INumericToolStat)ToolStats.MINING_SPEED))));
        }
    }

    protected void registerHooks(ModuleHookMap.Builder hookBuilder) {
        hookBuilder.addHook((Object)this, new ModuleHook[]{ModifierHooks.TOOLTIP, ModifierHooks.MELEE_DAMAGE, ModifierHooks.BREAK_SPEED, ModifierHooks.CONDITIONAL_STAT});
    }

    public float getMeleeDamage(@Nonnull IToolStackView tool, ModifierEntry modifier, @Nonnull ToolAttackContext context, float baseDamage, float damage) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int current = overslime.getShield(tool);
        if (current > 0) {
            return (float)((double)damage + Math.cbrt((float)current * tool.getMultiplier((INumericToolStat)ToolStats.ATTACK_DAMAGE)));
        }
        return damage;
    }

    public float modifyStat(IToolStackView tool, ModifierEntry modifier, LivingEntity living, FloatToolStat stat, float baseValue, float multiplier) {
        if (stat == ToolStats.DRAW_SPEED) {
            OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
            float current = overslime.getShield(tool);
            return (float)((double)baseValue + Math.cbrt((double)current * 0.004 * (double)tool.getMultiplier((INumericToolStat)ToolStats.DRAW_SPEED)));
        }
        return baseValue;
    }

    public void addTooltip(IToolStackView tool, ModifierEntry modifier, @Nullable Player player, List<Component> tooltip, TooltipKey tooltipKey, TooltipFlag tooltipFlag) {
        OverslimeModifier overslime = (OverslimeModifier)TinkerModifiers.overslime.get();
        int current = overslime.getShield(tool);
        boolean harvest = tool.hasTag(TinkerTags.Items.HARVEST);
        if ((harvest || tool.hasTag(TinkerTags.Items.RANGED)) && player != null && tooltipKey == TooltipKey.SHIFT) {
            if (harvest) {
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.ATTACK_DAMAGE, (TagKey)TinkerTags.Items.MELEE, (float)((float)Math.cbrt(current)), tooltip);
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.MINING_SPEED, (TagKey)TinkerTags.Items.HARVEST, (float)((float)Math.cbrt(current)), tooltip);
            } else {
                TooltipModifierHook.addStatBoost((IToolStackView)tool, (Modifier)modifier.getModifier(), (FloatToolStat)ToolStats.DRAW_SPEED, (TagKey)TinkerTags.Items.RANGED, (float)((float)Math.cbrt((double)current * 0.004)), tooltip);
            }
        }
    }
}

